/*
 * Decompiled with CFR 0.152.
 */
package com.quantumdata.fmteditor;

import com.quantumdata.fmteditor.FmtUI;
import com.quantumdata.fmteditor.Instrument;
import com.quantumdata.fmteditor.InstrumentListener;
import com.quantumdata.fmteditor.MsgLog;
import com.quantumdata.std.RemoteInstrument;
import com.quantumdata.widgets.QDLabel;
import com.quantumdata.widgets.QDPanel;
import com.quantumdata.widgets.QDProgressBar;
import com.quantumdata.widgets.QDStdUI;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JProgressBar;

public class StatusPanel
extends QDPanel
implements ActionListener,
InstrumentListener {
    private static final long serialVersionUID = 1L;
    private QDLabel m_message;
    private JButton m_led;
    private QDLabel m_connectStatus;
    private JProgressBar m_progBar;
    private static StatusPanel g_instance = null;

    public static StatusPanel instance() {
        if (g_instance == null) {
            g_instance = new StatusPanel();
        }
        return g_instance;
    }

    private StatusPanel() {
        this.setLayout(new BorderLayout());
        this.setBorder(BorderFactory.createLineBorder(QDStdUI.getActionForeground()));
        QDPanel qDPanel = new QDPanel();
        Icon icon = FmtUI.getIcon(2);
        this.m_led = new JButton();
        this.m_led.setFocusable(true);
        this.m_led.setContentAreaFilled(false);
        this.m_led.setSize(new Dimension(icon.getIconWidth(), icon.getIconHeight()));
        this.m_led.setEnabled(true);
        this.m_led.setMargin(new Insets(0, 0, 0, 0));
        this.m_led.addActionListener(this);
        this.m_led.setToolTipText("Clear the status");
        qDPanel.add((Component)this.m_led);
        this.m_message = new QDLabel();
        this.m_message.setForeground(Color.red);
        qDPanel.add((Component)this.m_message);
        this.add((Component)qDPanel, "West");
        this.m_connectStatus = new QDLabel();
        this.m_connectStatus.setBorder(BorderFactory.createLineBorder(QDStdUI.getActionForeground()));
        this.m_connectStatus.setToolTipText("The default Instrument connection");
        this.add((Component)this.m_connectStatus, "East");
        this.m_progBar = new QDProgressBar();
        this.add(this.m_progBar, "Center");
        this.m_progBar.setVisible(false);
        this.setErrorIndictor(false);
        Instrument.addListener(this);
        this.setIP("");
    }

    public void actionPerformed(ActionEvent actionEvent) {
        this.setErrorIndictor(false);
    }

    public void connected(RemoteInstrument remoteInstrument) {
        if (remoteInstrument == Instrument.getDefault()) {
            String string = remoteInstrument.getConnection().getName();
            this.setIP(string);
            MsgLog.msg("Connected to: " + string);
        }
    }

    public void disconnected(RemoteInstrument remoteInstrument) {
        if (remoteInstrument == Instrument.getDefault()) {
            this.setIP(null);
        }
    }

    public void setErrorIndictor(boolean bl) {
        if (bl) {
            this.m_led.setIcon(FmtUI.getIcon(2));
        } else {
            this.m_led.setIcon(FmtUI.getIcon(3));
            this.m_message.setText("");
        }
    }

    public void setWarningIndictor(boolean bl) {
        if (bl) {
            this.m_led.setIcon(FmtUI.getIcon(1));
        } else {
            this.m_led.setIcon(FmtUI.getIcon(3));
            this.m_message.setText("");
        }
    }

    public void setMessage(String string) {
        this.m_message.setText(string);
        if (string.length() == 0) {
            return;
        }
    }

    public void showProgress(String string) {
        this.m_progBar.setVisible(true);
        this.m_progBar.setIndeterminate(true);
        this.m_progBar.setStringPainted(true);
        this.m_progBar.setString(string);
    }

    public void startProgress(int n, int n2, String string) {
        this.m_progBar.setVisible(true);
        this.m_progBar.setIndeterminate(false);
        this.m_progBar.setMinimum(n);
        this.m_progBar.setMaximum(n2);
        this.m_progBar.setStringPainted(true);
        this.m_progBar.setString(string);
        this.m_progBar.setValue(n);
    }

    public void setProgress(int n, String string) {
        this.m_progBar.setValue(n);
        this.m_progBar.setString(string);
    }

    public void hideProgress() {
        this.m_progBar.setIndeterminate(false);
        this.m_progBar.setVisible(false);
    }

    public void setIP(String string) {
        if (string == null || string.length() == 0) {
            string = "Not Connected";
        }
        this.m_connectStatus.setText("    " + string + "    ");
    }
}

